//
//  GSVodTestViewController.m
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/8/11.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import "GSVodTestViewController.h"
#import "GSVodInfo.h"

@interface GSVodTestViewController ()<GSVodInfoDelegate>

@property (nonatomic, strong) NSMutableArray * dataArray;

@property (nonatomic, strong) NSMutableArray * viewsArray;

@end

@implementation GSVodTestViewController
- (void)dealloc{
    NSLog(@"GSVodTestViewController == dealloc");
}
- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createPlayerView];

}
- (void)clickButton:(UIButton *)sender{
    sender.selected = !sender.selected;

    if(sender.tag < self.dataArray.count){
        for (int i = 0; i < self.dataArray.count; i++) {
            GSVodInfo * vodInfo = self.dataArray[i];
            [vodInfo destroyVodPlayer];
        }
     
//        if(sender.selected){
//            [vodInfo.vodObj.player resume];
//        }else{
//            [vodInfo.vodObj.player pause];
//        }
    }

}
- (void)createPlayerView{
    self.dataArray = [[NSMutableArray alloc] init];

    NSString * rooms = @"54195892";
    // 24433313,85946754,00080214,87957144,29436879,05220242,98651557,39840100,82040835,87217444,94782256,04635404,77583062,25238254,82315546,22524767
    NSArray * roomsArray = [rooms componentsSeparatedByString:@","];
    
    for (int i = 0; i < roomsArray.count; i++) {
        GSVodInfo * vodInfo1 = [[GSVodInfo alloc] initWith:@"emoney.gensee.com" nickName:[NSString stringWithFormat:@"测试%d",i] serviceType:GSBroadcastServiceTypeWebcast roomNumber:roomsArray[i] watchPassword:@""];

        [self.dataArray addObject:vodInfo1];
    }

    self.viewsArray = [[NSMutableArray alloc] init];
    for (int i = 0; i < self.dataArray.count; i++) {
        VodGLView * vodView = [[VodGLView alloc] initWithFrame:CGRectMake(50 + self.view.frame.size.width/2*(i%2), 200 *(i/2), 200, 200)];
        NSLog(@"vodView %f %f",vodView.frame.origin.x,vodView.frame.origin.y);
        UIButton * button = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 100, 50)];
        button.tag = i;
        button.backgroundColor = [UIColor lightGrayColor];
        [button addTarget:self action:@selector(clickButton:) forControlEvents:UIControlEventTouchUpInside];
        [button setTitle:@"播放" forState:UIControlStateNormal];
        [button setTitle:@"暂停" forState:UIControlStateSelected];
        button.selected = YES;
        button.center = CGPointMake(100, 100);
        [vodView addSubview:button];
        [self.view addSubview:vodView];
        [self.viewsArray addObject:vodView];
        GSVodInfo * vodInfo = self.dataArray[i];
        vodInfo.row = i;
        vodInfo.vodInfoDelegate = self;
        [vodInfo requestVodItemAndCreatePlayer];
    }
}
- (void)onVodPlayerCreate:(BOOL)isSuccess Row:(NSInteger)row{
    GSVodInfo * vodInfo = self.dataArray[row];
    VodGLView * vodView = self.viewsArray[row];

    if(vodInfo.vodObj.player.playItem != nil){
        vodInfo.vodObj.player.mVideoView = vodView;
//        [vodInfo.vodObj.player resume];
    }

}
@end
